/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.world.structure;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.world.BlockLogicUtil;
import com.aetherteam.aether.world.structure.AetherStructureTypes;
import com.aetherteam.aether.world.structurepiece.golddungeon.GoldBossRoom;
import com.aetherteam.aether.world.structurepiece.golddungeon.GoldIsland;
import com.aetherteam.aether.world.structurepiece.golddungeon.GoldStub;
import com.aetherteam.aether.world.structurepiece.golddungeon.GoldStubCave;
import com.aetherteam.aether.world.structurepiece.golddungeon.GoldTunnel;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class GoldDungeonStructure
extends Structure {
    public static final Codec<GoldDungeonStructure> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)GoldDungeonStructure.m_226567_((RecordCodecBuilder.Instance)builder), (App)Codec.INT.fieldOf("stubcount").forGetter(o -> o.stubIslandCount), (App)Codec.INT.fieldOf("belowTerrain").forGetter(o -> o.belowTerrain), (App)Codec.INT.fieldOf("minY").forGetter(o -> o.minY), (App)Codec.INT.fieldOf("rangeY").forGetter(o -> o.rangeY), (App)PlacedFeature.f_191773_.fieldOf("islandFoliage").forGetter(p_204928_ -> p_204928_.islandFoliage), (App)PlacedFeature.f_191773_.fieldOf("stubFoliage").forGetter(p_204928_ -> p_204928_.stubFoliage)).apply((Applicative)builder, GoldDungeonStructure::new));
    private final int stubIslandCount;
    private final int belowTerrain;
    private final int minY;
    private final int rangeY;
    private final Holder<PlacedFeature> islandFoliage;
    private final Holder<PlacedFeature> stubFoliage;

    public GoldDungeonStructure(Structure.StructureSettings settings, int stubIslandCount, int belowTerrain, int minY, int rangeY, Holder<PlacedFeature> islandFoliage, Holder<PlacedFeature> stubFoliage) {
        super(settings);
        this.stubIslandCount = stubIslandCount;
        this.belowTerrain = belowTerrain;
        this.minY = minY;
        this.rangeY = rangeY;
        this.islandFoliage = islandFoliage;
        this.stubFoliage = stubFoliage;
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        WorldgenRandom random = context.f_226626_();
        ChunkPos chunkpos = context.f_226628_();
        int x = chunkpos.m_151390_();
        int z = chunkpos.m_151393_();
        int terrainHeight = context.f_226622_().m_214096_(x, z, Heightmap.Types.WORLD_SURFACE_WG, context.f_226629_(), context.f_226624_()) - this.belowTerrain;
        int height = this.minY + random.m_188503_(this.rangeY);
        height = Math.max(terrainHeight, height);
        BlockPos blockpos = new BlockPos(chunkpos.m_151390_(), height, chunkpos.m_151393_());
        return Optional.of(new Structure.GenerationStub(blockpos, piecesBuilder -> this.generatePieces((StructurePiecesBuilder)piecesBuilder, context, blockpos)));
    }

    private void generatePieces(StructurePiecesBuilder builder, Structure.GenerationContext context, BlockPos elevatedPos) {
        WorldgenRandom random = context.f_226626_();
        StructureTemplateManager templateManager = context.f_226625_();
        GoldIsland island = new GoldIsland(templateManager, "island", elevatedPos);
        builder.m_142679_((StructurePiece)island);
        BlockPos centerPos = island.m_73547_().m_162394_();
        Vec3i stubOffset = this.getStubOffset(templateManager);
        this.addIslandStubs(templateManager, builder, (RandomSource)random, centerPos, stubOffset);
        this.placeGumdropCaves(builder, (RandomSource)random, centerPos);
        Rotation rotation = Rotation.m_221990_((RandomSource)random);
        BlockPos bossPos = centerPos.m_121955_(this.getBossRoomOffset(templateManager, rotation.m_55954_(Direction.SOUTH)));
        GoldBossRoom bossRoom = new GoldBossRoom(templateManager, "boss_room", bossPos, rotation);
        int verticalOffset = this.tunnelFromBossRoom(templateManager, builder, (StructurePiece)bossRoom, context.f_226622_(), context.f_226629_(), context.f_226624_());
        builder.m_142679_((StructurePiece)bossRoom);
        if (verticalOffset > 0) {
            builder.m_192781_(verticalOffset);
        }
    }

    private void addIslandStubs(StructureTemplateManager templateManager, StructurePiecesBuilder builder, RandomSource random, BlockPos center, Vec3i stubOffset) {
        int stubCount = this.stubIslandCount + random.m_188503_(5);
        for (int stubIslands = 0; stubIslands < stubCount; ++stubIslands) {
            float angle = random.m_188501_() * ((float)Math.PI * 2);
            float distance = (random.m_188501_() * 0.125f + 0.7f) * 24.0f;
            int xOffset = Mth.m_14107_((double)(Math.cos(angle) * (double)distance));
            int yOffset = -Mth.m_14107_((double)(24.0 * (double)random.m_188501_() * 0.3));
            int zOffset = Mth.m_14107_((double)(-Math.sin(angle) * (double)distance));
            BlockPos stubPos = center.m_7918_(xOffset, yOffset, zOffset);
            stubPos = stubPos.m_121955_(stubOffset);
            GoldStub stub = new GoldStub(templateManager, "stub", stubPos);
            builder.m_142679_((StructurePiece)stub);
        }
    }

    private void placeGumdropCaves(StructurePiecesBuilder builder, RandomSource random, BlockPos center) {
        for (int count = 0; count < 18; ++count) {
            int x = center.m_123341_() + random.m_188503_(24) - random.m_188503_(24);
            int y = center.m_123342_() + random.m_188503_(24) - random.m_188503_(24);
            int z = center.m_123343_() + random.m_188503_(24) - random.m_188503_(24);
            builder.m_142679_((StructurePiece)new GoldStubCave(new BoundingBox(new BlockPos(x, y, z))));
        }
    }

    private int tunnelFromBossRoom(StructureTemplateManager templateManager, StructurePiecesBuilder builder, StructurePiece room, ChunkGenerator chunkGenerator, LevelHeightAccessor heightAccessor, RandomState randomState) {
        StructureTemplate template = templateManager.m_230359_(new ResourceLocation("aether", "gold_dungeon/tunnel"));
        int width = template.m_163801_().m_123341_();
        Rotation rotation = room.m_6830_();
        Direction direction = rotation.m_55954_(Direction.SOUTH);
        BlockPos startPos = BlockLogicUtil.tunnelFromOddSquareRoom(room.m_73547_(), direction, width);
        startPos = startPos.m_7918_(direction.m_122429_() * 3, 1, direction.m_122431_() * 3);
        GoldTunnel tunnel = new GoldTunnel(templateManager, "tunnel", startPos, rotation);
        builder.m_142679_((StructurePiece)tunnel);
        BlockPos endPos = BlockLogicUtil.tunnelFromEvenSquareRoom(tunnel.m_73547_(), direction, tunnel.m_226911_().m_163801_().m_123341_());
        return chunkGenerator.m_223221_(endPos.m_123341_(), endPos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, heightAccessor, randomState) - startPos.m_123342_();
    }

    private Vec3i getStubOffset(StructureTemplateManager templateManager) {
        StructureTemplate template = templateManager.m_230359_(new ResourceLocation("aether", "gold_dungeon/stub"));
        Vec3i size = template.m_163801_();
        return new Vec3i(size.m_123341_() / -2, size.m_123342_() / -2, size.m_123343_() / -2);
    }

    private Vec3i getBossRoomOffset(StructureTemplateManager templateManager, Direction direction) {
        StructureTemplate template = templateManager.m_230359_(new ResourceLocation("aether", "gold_dungeon/boss_room"));
        Vec3i size = template.m_163801_();
        Vec3i offset = new Vec3i(size.m_123341_() / -2, size.m_123342_() / -2, size.m_123343_() / -2);
        return offset.m_5484_(direction, -1);
    }

    public void m_214110_(WorldGenLevel level, StructureManager structureManager, ChunkGenerator generator, RandomSource random, BoundingBox chunkBox, ChunkPos chunkPos, PiecesContainer pieces) {
        for (StructurePiece piece : pieces.f_192741_()) {
            if (piece instanceof GoldIsland) {
                GoldIsland island = (GoldIsland)piece;
                GoldDungeonStructure.placeGoldenOaks(level, generator, random, island.m_73547_(), chunkBox, this.islandFoliage);
                continue;
            }
            if (!(piece instanceof GoldStub)) continue;
            GoldStub stub = (GoldStub)piece;
            GoldDungeonStructure.placeGoldenOaks(level, generator, random, stub.m_73547_(), chunkBox, this.stubFoliage);
        }
    }

    private static void placeGoldenOaks(WorldGenLevel level, ChunkGenerator generator, RandomSource random, BoundingBox boundingBox, BoundingBox chunkBox, Holder<PlacedFeature> feature) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        int minX = Math.max(chunkBox.m_162395_(), boundingBox.m_162395_());
        int minZ = Math.max(chunkBox.m_162398_(), boundingBox.m_162398_());
        int maxX = Math.min(chunkBox.m_162399_(), boundingBox.m_162399_());
        int maxZ = Math.min(chunkBox.m_162401_(), boundingBox.m_162401_());
        int minY = boundingBox.m_162396_() + Mth.m_14107_((double)((double)(boundingBox.m_162400_() - boundingBox.m_162396_()) * 0.75));
        int maxY = boundingBox.m_162400_();
        PlacedFeature placement = (PlacedFeature)feature.m_203334_();
        for (int x = minX; x < maxX; ++x) {
            for (int z = minZ; z < maxZ; ++z) {
                mutable.m_122178_(x, maxY, z);
                if (!GoldDungeonStructure.iterateColumn(level, mutable, minY, maxY)) continue;
                placement.m_226357_(level, generator, random, (BlockPos)mutable);
            }
        }
    }

    private static boolean iterateColumn(WorldGenLevel level, BlockPos.MutableBlockPos pos, int minY, int maxY) {
        for (int y = maxY; y > minY; --y) {
            pos.m_142448_(y);
            if (!level.m_8055_((BlockPos)pos).m_204336_(AetherTags.Blocks.AETHER_DIRT)) continue;
            pos.m_142448_(++y);
            return true;
        }
        return false;
    }

    public StructureType<?> m_213658_() {
        return (StructureType)AetherStructureTypes.GOLD_DUNGEON.get();
    }
}

